# Figure lois a priori normales

n0 <- c(0.1,1,10)
x <- seq(-10,10,by=0.01)
norm.mat <- matrix(NA,nrow=length(n0),ncol=length(x))
for (i in 1:length(n0)) {
norm.mat[i,] <- dnorm(x,mean=0,sd=sqrt(1/n0[i]))}

plot(rep(x,times=length(n0)),as.vector(norm.mat),type="n",xlab=expression(mu),ylab=expression("[" * mu * "]"))
lines(x,norm.mat[1,],lty=2)
lines(x,norm.mat[2,],lty=3)
lines(x,norm.mat[3,],lty=4)
legend(-10,1.2,legend=c("n0=0.1","n0=1","n0=10"),lty=2:4,ncol=1)

# Figure loi a priori pour phi=logit(p)

x <- ((-500):500)/100
prior <- exp(x)/(exp(x)+1)^2
plot(x,prior,type="l",xlab=expression(phi),ylab=expression("[" * phi * "]"))

# Figure lois a priori de Jeffreys

par(mfrow=c(2,2))

x <- seq(0,1,by=0.001)
beta_0.5_0.5 <- dbeta(x=x, shape1=1/2, shape2=1/2, ncp = 0, log = FALSE)
plot(x,beta_0.5_0.5,type="l",xlab="p",ylab="[p]",
     main=expression("Modèle binomial"))

x <- seq(0,10,by=0.01)
plot(x,1/sqrt(x),type="l",xlab=expression(theta),ylab=expression("[" * theta * "]"),
     main=expression("Modèle de Poisson"))

x <- seq(-5,5,by=0.01)
plot(x,rep(1,times=length(x)),type="l",xlab=expression(mu),ylab=expression("[" * mu * "]"),
     main=expression("Modèle normal (" * mu * ")"))

x <- seq(0,10,by=0.01)
plot(x,1/x,type="l",xlab=expression(tau),ylab=expression("[" * tau * "]"),
     main=expression("Modèle normal (" * tau * ")"))

dev.off()
q()

