#####  Script R associé au chapitre 5 -- Méthodes numériques pour estimer les lois a posteriori
#####  Version du 11 octobre 2013
#####  Version R 3.0.2 (2013-09-25) -- "Frisbee Sailing"
#####  Auteur: Samuel Soubeyrand


##########################################################
##########################################################
#####         Taille d'échantillon et précision de l'estimation d'une densité
##########################################################
##########################################################

## Petit échantillon
n=200
z=rbinom(n,1,0.5)
y=rnorm(n,-0.5,1)*z+rgamma(n,shape=2,scale=3)*(1-z)
hist(y,breaks=50,xlab=expression(theta),ylab="Densité",main="",col=grey(0.8),
     border=grey(0.8),freq=F,xlim=c(-5,30),ylim=c(0,0.25))
x=seq(-10,50,l=2000)
lines(x,0.5*dnorm(x,-0.5,1)+0.5*dgamma(x,shape=2,scale=3),lwd=2,col=1)
lines(density(y),lwd=2,lty="dashed")
lines(density(y,bw=3),lwd=2,lty="dotted")

## Grand échantillon
n=2000
z=rbinom(n,1,0.5)
y=rnorm(n,-0.5,1)*z+rgamma(n,shape=2,scale=3)*(1-z)
hist(y,breaks=100,xlab=expression(theta),ylab="Densité",main="",col=grey(0.8),
     border=grey(0.8),freq=F,xlim=c(-5,30),ylim=c(0,0.25))
x=seq(-10,50,l=2000)
lines(x,0.5*dnorm(x,-0.5,1)+0.5*dgamma(x,shape=2,scale=3),lwd=2,col=1)
lines(density(y),lwd=2,lty="dashed")
lines(density(y,bw=3),lwd=2,lty="dotted")


##########################################################
##########################################################
##### 			Représentation d'une chaîne
##########################################################
##########################################################

## Lecture d'une chaîne MCMC déjà simulée
y=read.table("chain.txt")

par(mfrow=c(1,3))
## Début de la chaîne
plot(y[1:100,],xlab="Itération",ylab=expression(theta),type="l",ylim=range(y[,2]))
## Toute la chaîne
plot(y,xlab="Itération",ylab=expression(theta),type="l",ylim=range(y[,2]))
## Histogramme des valeurs prises par la chaîne après la phase transitoire
ysub=y[-(1:100),2]
h=hist(ysub,breaks=bk<-seq(-5,40,2.5),plot=FALSE)
barplot(h$counts,bk[2:length(bk)]-bk[1:(length(bk)-1)],space=0,horiz=T,
	col=grey(0.3),border=grey(0.3),xlab="Fréquence",ylab=expression(theta))
axis(2,seq(5,45,10),paste(seq(0,40,10)),cex.axis=2)


##########################################################
##########################################################
##### 			Exemple métapopulationnel
##########################################################
##########################################################


##########################################################
#####          Fonctions exemple métapop

## Potentiel infectieux
S=function(par,r,O){
  sum(O*par[1]/(2*pi*par[2]^2)*exp(-r/par[2]))
}

## Vraisemblance
llik.dissemination=function(Y,D,theta){
  M=ncol(Y)
  N=nrow(Y)
  out=0
  for(m in 2:M){
	for(i in (1:N)[Y[,m-1]==0]){
	    out=out+dbinom(Y[i,m],1,1-exp(-S(theta[1:2],D[i,],Y[,m-1])),log=TRUE)
  	}
  }
  out
}

## Log-densité de la loi a priori
lprior=function(theta,a){
  dexp(theta[1],1/a[1],log=TRUE)+dexp(theta[2],1/a[2],log=TRUE)
}

## Densité de la loi a priori
prior=function(theta,a){
  cbind(dexp(theta[,1],1/a[1]),dexp(theta[,2],1/a[2]))
}


##########################################################
#####          Représentation schématique d'un potentiel infectieux

parametres=c(0.2,0.05)
aa=c(0.2,0.3,0.35,0.45,0.8,0.83)
DD=abs(outer(aa,aa,"-"))
DDD=abs(outer(seq(0,1,l=300),aa,"-"))
AA=c(0,1,1,1,0,1)
SS=apply(DDD,1,function(r) S(parametres,r,AA))
SSS=apply(DD,1,function(r) S(parametres,r,AA))
plot(seq(0,1,l=300),SS,type="l",xlab="x",ylab="S(x)",lwd=6,col=grey(0.7))
points(aa,rep(0,length(aa)),pch=1+18*AA,lwd=1.5,cex=1.5)
for(i in (1:length(aa))[AA==1]){
	lines(seq(0,1,l=300),
		parametres[1]/2/pi/parametres[2]^2*exp(-abs(seq(0,1,l=300)-aa[i])/parametres[2]),
		lty="solid",col=1,lwd=1.5)
}
values=paste("S(",aa,")",sep="")
for(i in (1:length(aa))[AA==0]){
	lines(rep(aa[i],2),c(0,SSS[i]),lty="dashed")
	lines(c(-10,aa[i]),rep(SSS[i],2),lty="dashed")
	mtext(values[i],side=2,at=SSS[i],cex=1,las=1,line=0.3)
}


##########################################################
#####          Données métapop -- Simulation des données

N=100
theta=c(0.2,0.05)
x=cbind(runif(N,0,1),runif(N,0,1))
D=sqrt(outer(x[,1],x[,1],"-")^2+outer(x[,2],x[,2],"-")^2)
M=3
Y=cbind(rep(0,N))
sourcelim=0.5
sourcepr=1
Y[x[,1]<sourcelim & x[,2]<sourcelim,]=rbinom(sum(x[,1]<sourcelim & x[,2]<sourcelim),1,
	sourcepr)
for(m in 2:M){
  newY=Y[,m-1]
  for(i in (1:N)[Y[,m-1]==0]){
    newY[i]=rbinom(1,1,1-exp(-S(theta[1:2],D[i,],Y[,m-1])))
  }
  Y=cbind(Y,newY)
}

## Graphe positions des hôtes
par(mfrow=c(1,1))
plot(x,pch=19,asp=1,xlab="x (1ère coordonnée)",ylab="x (2ème coordonnée)",
  	cex.lab=1.5,cex.axis=1.5)

## Graphes épidémie observée
par(mfrow=c(1,3))
for(m in 1:M) {
  	plot(x,pch=19,asp=1,xlab="x (1ère coordonnée)",ylab="x (2ème coordonnée)",
	  	cex.lab=1.5,cex.axis=1.5,col=1+(Y[,m]==1))
}


##########################################################
#####          Données métapop -- Lecture des données utilisées dans le chapitre

## Lecture des données
source("simul.metapop1.R")
Y=temp$Y
N=temp$N
theta=temp$theta
x=temp$x
D=sqrt(outer(x[,1],x[,1],"-")^2+outer(x[,2],x[,2],"-")^2)
M=3

## Graphe positions des hôtes
par(mfrow=c(1,1))
plot(x,pch=19,asp=1,xlab="x (1ère coordonnée)",ylab="x (2ème coordonnée)",
  	cex.lab=1.5,cex.axis=1.5)

## Graphes épidémie observée
par(mfrow=c(1,3))
for(m in 1:M) {
  	plot(x,pch=19,asp=1,xlab="x (1ère coordonnée)",ylab="x (2ème coordonnée)",
	  	cex.lab=1.5,cex.axis=1.5,col=1+(Y[,m]==1))
}


##########################################################
#####          Fonctions ré-échantillonnage par importance

## Fonction de simulation sous la loi de proposition
rproposal=function(n,par.proposal){
	cbind(rexp(n,1/par.proposal[1]),rexp(n,1/par.proposal[2]))
}

## Fonction logdensité de la loi de proposition
ldproposal=function(theta,par.proposal){
	dexp(theta[,1],1/par.proposal[1],log=TRUE)+dexp(theta[,2],1/par.proposal[2],log=TRUE)
}

## Implémentation du ré-échantillonnage par importance
SIR=function(n,Y,D,a,par.proposal,nprime=n){
	## n: nb de tirage, Y: états sanitaires, D: matrice distance inter-hôtes, a: paramètres de la loi a priori, par.proposal: paramètres de la loi de proposition, nprime: nb de ré-échantillonnage
	## simulation d'un échantillon sous la loi de proposition
	theta=rproposal(n,par.proposal)
	## calcul des termes intervenant dans le calcul des poids
	## logvraisemblance et logprior (seule ligne de la fonction qui dépend du modèle)
	lcible=apply(theta,1,function(th) llik.dissemination(Y,D,th)+lprior(th,a))  
	## logproposal
	lprop=ldproposal(theta,par.proposal)
	## calcul des poids
	lpoids=lcible-lprop
	lpoids=lpoids-max(lpoids)+100 ## ajout d'une cste (indolore) pour des raisons numériques
	poids=exp(lpoids)
	## ré-échantillonnage
 	keep=rmultinom(1,nprime,poids)
  	print(poids)
  	keep.rep=rep(1:n,keep)
  	## output: 
  	## proposed: échantillon initial des paramètres, keep.rep: numéros des paramètres de l'échantillon initial qui sont conservés (avec répétition possibles), posterior: échantillon a posteriori 
  	list(proposed=theta,keep.rep=keep.rep,posterior=theta[keep.rep,])
}


############################################################
#####          Application ré-échantillonnage par importance aux données métapop

## Ré-échantillonnage par importance (ATTENTION : COUTEUX EN TEMPS DE CALCUL)
par.prior=c(2,2)
ech1=SIR(n=10^5,Y=Y,D=D,a=par.prior,par.proposal=c(2,2),nprime=10^4)

## Calcul de quantiles à posteriori
apply(ech1$post,2,quantile,c(0.025,0.5,0.975))

## Graphiques
par(mfrow=c(1,3))
## Echantillon a posteriori marginal pour theta1
i=1
hist(ech1$post[,i],breaks=16,freq=FALSE,xlab=expression(theta[1]),ylab="Densité",
	main="",ylim=c(0,5.5),col=grey(0.7),border=grey(0.7))
abline(v=theta[i],col=1,lwd=1.5)
lines(seq(0,5,l=200),prior(cbind(seq(0,5,l=200),seq(0,5,l=200)),par.prior)[,i],col=1,
		lwd=1.5,lty="dotted")
box()
## Echantillon a posteriori marginal pour theta2
i=2	
hist(ech1$post[,i],breaks=8,freq=FALSE,xlim=c(0,0.2),xlab=expression(theta[2]),ylab="Densité",
	main="",ylim=c(0,55),col=grey(0.7),border=grey(0.7))
abline(v=theta[i],col=1,lwd=1.5)
lines(seq(0,5,l=200),prior(cbind(seq(0,5,l=200),seq(0,5,l=200)),par.prior)[,i],col=1,
		lwd=1.5,lty="dotted")
box()
## Echantillon a posteriori joint pour theta1 et theta2
draw.nb=NULL
for(i in 1:nrow(ech1$prop)){
	draw.nb=c(draw.nb,sum(ech1$keep.rep==i))
}
plot(ech1$prop[,1],ech1$prop[,2],col=grey(0.7),cex=draw.nb/max(draw.nb)*3,
	xlab=expression(theta[1]),ylab=expression(theta[2]),
	xlim=range(ech1$post[,1]),ylim=range(ech1$post[,2]))
points(theta[1],theta[2],col=1,lwd=2,pch=19,cex=1)


############################################################
#####          Application MCMC aux données métapop complètes

## Implémentation du MCMC - Metropolis-Hastings
mcmc=function(n,Y,D,parprior,theta0,parprop,savepar){
  M=ncol(Y)
  theta=rbind(theta0)
  thetai=theta0
  for(i in 2:n){
  	## update of the dissemination parameters
    thetaprop=rgamma(2,shape=thetai^2/parprop^2,scale=parprop^2/thetai)
    pr=min(1,exp((llik.dissemination(Y,D,thetaprop)+lprior(thetaprop,parprior))-
      (llik.dissemination(Y,D,thetai)+lprior(thetai,parprior))+
      sum(dgamma(thetai,shape=thetaprop^2/parprop^2,
      	scale=parprop^2/thetaprop,log=TRUE))-
      sum(dgamma(thetaprop,shape=thetai^2/parprop^2,
      	scale=parprop^2/thetai,log=TRUE))))
    if(is.na(pr)){ pr=0 }
    if(runif(1)<pr){ thetai=thetaprop }
    if(i/savepar==round(i/savepar)){
      theta=rbind(theta,thetai)
      print(c(i,thetai))
    }
  }
  list(Y=Y,parprior=parprior,parprop=parprop,savepar=savepar,theta=theta)
}

## Application du MCMC (ATTENTION : COUTEUX EN TEMPS DE CALCUL)
temp=mcmc(n=5*10^5,Y,D,parprior=c(2,2),theta0=c(0.5,0.5),parprop=c(0.1,0.1),savepar=50)

## Graphiques 
par(mfrow=c(2,2))
burn=200
## Echantillon a posteriori marginal pour theta1
i=1
# Chaîne
plot((1+0:(nrow(temp$theta)-1)*temp$savepar)[-(1:burn)],temp$theta[-(1:burn),i],
	ylim=c(0,1.5),col=grey(0.7),type="l",xlab="Itération",ylab=expression(theta[1]),axes=F)
box()
axis(1,at=c(0,2.5*10^5, 5*10^5))
axis(2)
abline(h=theta[i],col=1,lwd=1.5)
# Histogramme
hist(temp$theta[-(1:burn),i],breaks=seq(0,1.5,0.075),freq=FALSE,xlim=c(0,1.5),
	xlab=expression(theta[1]),ylab="Densité",main="",ylim=c(0,5.5),col=grey(0.7),border=grey(0.7))
abline(v=theta[i],col=1,lwd=1.5)
lines(seq(0,5,l=200),prior(cbind(seq(0,5,l=200),seq(0,5,l=200)),temp$parprior)[,i],col=1,
	lwd=1.5,lty="dotted")
box()
## Echantillon a posteriori marginal pour theta2
i=2	
# Chaîne
plot((1+0:(nrow(temp$theta)-1)*temp$savepar)[-(1:burn)],temp$theta[-(1:burn),i],
	ylim=c(0,0.2),col=grey(0.7),type="l",xlab="Itération",ylab=expression(theta[2]),axes=F)
box()
axis(1,at=c(0,2.5*10^5, 5*10^5))
axis(2)
abline(h=theta[i],col=1,lwd=1.5)
# Histogramme
hist(temp$theta[-(1:burn),i],breaks=seq(0,0.2,0.0075),freq=FALSE,xlim=c(0,0.2),
	xlab=expression(theta[2]),ylab="Densité",main="",ylim=c(0,55),col=grey(0.7),border=grey(0.7))
abline(v=theta[i],col=1,lwd=1.5)
lines(seq(0,5,l=200),prior(cbind(seq(0,5,l=200),seq(0,5,l=200)),temp$parprior)[,i],col=1,
	lwd=1.5,lty="dotted")
box()
## Echantillon a posteriori joint 
par(mfrow=c(1,1))
th=expand.grid(seq(0,1.5,l=20),seq(0,0.2,l=20))
pp=prior(th,temp$parprior)
pp=matrix(pp[,1]*pp[,2],20,20)
contour(seq(0,1.5,l=20),seq(0,0.2,l=20),z=pp,xlim=c(0,1.5),ylim=c(0,0.2),col=0,
	xlab=expression(theta[1]),ylab=expression(theta[2]),labcex=1.5,lwd=1.5)
points(temp$theta[-(1:burn),1],temp$theta[-(1:burn),2],pch=".",col=grey(0.7))
contour(seq(0,1.5,l=20),seq(0,0.2,l=20),z=pp,col=1,lwd=1.5,labcex=1.5,add=TRUE)
points(theta[1],theta[2],col=1,lwd=2,pch=19,cex=1)


############################################################
#####          Application MCMC aux données métapop non complètes temporellement

## Implémentation du MCMC - Metropolis-Hastings
mcmc2=function(n,Y1,Y3,D,parprior,theta0,Y20,parprop,savepar){
  N=length(Y1)
  theta=rbind(theta0)
  thetai=theta0
  Y2=rbind(Y20)
  Y2i=Y20
  for(i in 2:n){
  	## update of the dissemination parameters
    thetaprop=rgamma(2,shape=thetai^2/parprop[1:2]^2,scale=parprop[1:2]^2/thetai)
    pr=min(1,exp((llik.dissemination(cbind(Y1,Y2i,Y3),D,thetaprop)+lprior(thetaprop,parprior))-
      (llik.dissemination(cbind(Y1,Y2i,Y3),D,thetai)+lprior(thetai,parprior))+
      sum(dgamma(thetai,shape=thetaprop^2/parprop[1:2]^2,
      	scale=parprop[1:2]^2/thetaprop,log=TRUE))-
      sum(dgamma(thetaprop,shape=thetai^2/parprop[1:2]^2,
        scale=parprop[1:2]^2/thetai,log=TRUE))))
    if(is.na(pr)){ pr=0 }
    if(runif(1)<pr){ thetai=thetaprop }
    ## update of extinction states
    nb.update=10
    seq.update=sample((1:N)[Y1==0 & Y3==1],nb.update,replace=FALSE)
	Y2prop=Y2i
	Y2prop[seq.update]=rbinom(nb.update,1,parprop[3])
    pr=min(1,exp(llik.dissemination(cbind(Y1,Y2prop,Y3),D,thetai)-
    		llik.dissemination(cbind(Y1,Y2i,Y3),D,thetai)+
    		sum(dbinom(Y2i[seq.update],1,parprop[3],log=TRUE))-
    		sum(dbinom(Y2prop[seq.update],1,parprop[3],log=TRUE))))
    if(is.na(pr)){ pr=0 }
    if(runif(1)<pr){ Y2i=Y2prop }
    if(i/savepar==round(i/savepar)){
    	theta=rbind(theta,thetai)
    	Y2=rbind(Y2,Y2i)
		print(c(i,thetai))
  	}
  }
  list(Y1=Y1,Y2=Y2,Y3=Y3,parprior=parprior,parprop=parprop,savepar=savepar,
  	theta=theta)
}

## Application du MCMC (ATTENTION : COUTEUX EN TEMPS DE CALCUL)
temp=mcmc2(n=5*10^5,Y1=Y[,1],Y3=Y[,3],D,parprior=c(2,2),theta0=c(0.5,0.5),
	Y20=Y[,1],parprop=c(0.1,0.1,0.5),savepar=50)

## Graphiques 
par(mfrow=c(2,2))
burn=200
## Echantillon a posteriori marginal pour theta1
i=1
# Chaîne
plot((1+0:(nrow(temp$theta)-1)*temp$savepar)[-(1:burn)],temp$theta[-(1:burn),i],
	ylim=c(0,1.5),col=grey(0.7),type="l",xlab="Itération",ylab=expression(theta[1]),axes=F)
box()
axis(1,at=c(0,2.5*10^5, 5*10^5))
axis(2)
abline(h=theta[i],col=1,lwd=1.5)
# Histogramme
hist(temp$theta[-(1:burn),i],breaks=seq(0,1.5,0.075),freq=FALSE,xlim=c(0,1.5),
	xlab=expression(theta[1]),ylab="Densité",main="",ylim=c(0,5.5),col=grey(0.7),border=grey(0.7))
abline(v=theta[i],col=1,lwd=1.5)
lines(seq(0,5,l=200),prior(cbind(seq(0,5,l=200),seq(0,5,l=200)),temp$parprior)[,i],col=1,
	lwd=1.5,lty="dotted")
box()
## Echantillon a posteriori marginal pour theta2
i=2	
# Chaîne
plot((1+0:(nrow(temp$theta)-1)*temp$savepar)[-(1:burn)],temp$theta[-(1:burn),i],
	ylim=c(0,0.2),col=grey(0.7),type="l",xlab="Itération",ylab=expression(theta[2]),axes=F)
box()
axis(1,at=c(0,2.5*10^5, 5*10^5))
axis(2)
abline(h=theta[i],col=1,lwd=1.5)
# Histogramme
hist(temp$theta[-(1:burn),i],breaks=seq(0,0.2,0.0075),freq=FALSE,xlim=c(0,0.2),
	xlab=expression(theta[2]),ylab="Densité",main="",ylim=c(0,55),col=grey(0.7),border=grey(0.7))
abline(v=theta[i],col=1,lwd=1.5)
lines(seq(0,5,l=200),prior(cbind(seq(0,5,l=200),seq(0,5,l=200)),temp$parprior)[,i],col=1,
	lwd=1.5,lty="dotted")
box()
## Echantillon a posteriori joint 
par(mfrow=c(1,1))
th=expand.grid(seq(0,1.5,l=20),seq(0,0.2,l=20))
pp=prior(th,temp$parprior)
pp=matrix(pp[,1]*pp[,2],20,20)
contour(seq(0,1.5,l=20),seq(0,0.2,l=20),z=pp,xlim=c(0,1.5),ylim=c(0,0.2),col=0,
	xlab=expression(theta[1]),ylab=expression(theta[2]),labcex=1.5,lwd=1.5)
points(temp$theta[-(1:burn),1],temp$theta[-(1:burn),2],pch=".",col=grey(0.7))
contour(seq(0,1.5,l=20),seq(0,0.2,l=20),z=pp,col=1,lwd=1.5,labcex=1.5,add=TRUE)
points(theta[1],theta[2],col=1,lwd=2,pch=19,cex=1)


############################################################
#####          Application MCMC aux données métapop non complètes temporellement et spatialement

## Implémentation du MCMC - hybride Metropolis-Hastings / Gibbs
mcmc3=function(n,Y1,Y2,Y30,D,parprior,theta0,hidden3,parprop,savepar){
    N=length(Y1)
    theta=rbind(theta0)
    thetai=theta0
    Y3=rbind(Y30)
    Y3i=Y30
    for(i in 2:n){
        ## update of the dissemination parameters
        thetaprop=rgamma(2,shape=thetai^2/parprop[1:2]^2,scale=parprop[1:2]^2/thetai)
        pr=min(1,exp((llik.dissemination(cbind(Y1,Y2,Y3i),D,thetaprop)+
        	lprior(thetaprop,parprior))-
        	(llik.dissemination(cbind(Y1,Y2,Y3i),D,thetai)+lprior(thetai,parprior))+
        	sum(dgamma(thetai,shape=thetaprop^2/parprop[1:2]^2,
      				scale=parprop[1:2]^2/thetaprop,log=TRUE))-
        	sum(dgamma(thetaprop,shape=thetai^2/parprop[1:2]^2,
        			scale=parprop[1:2]^2/thetai,log=TRUE))))
        if(is.na(pr)){ pr=0 }
        if(runif(1)<pr){ thetai=thetaprop }
        ## update of extinction states (Gibbs)
        nb.update=10
        seq.update=sample(hidden3,nb.update,replace=FALSE)
        for(j in seq.update){
        	Y3i[j]=rbinom(1,1,1-exp(-S(thetai,D[j,],Y[,2])))
        }
        if(i/savepar==round(i/savepar)){
            theta=rbind(theta,thetai)
            Y3=rbind(Y3,Y3i)
            print(c(i,thetai))
        }
    }
    list(Y1=Y1,Y2=Y2,Y3=Y3,parprior=parprior,parprop=parprop,savepar=savepar,
  	theta=theta)
}

## Application du MCMC (ATTENTION : COUTEUX EN TEMPS DE CALCUL)
# Initialisation de Y3
hidden=(1:N)[x[,1]>0.65 & Y[,2]==0]
Y3=Y[,3]
Y3[hidden]=0
# Mise en oeuvre de l'algorithme
temp=mcmc3(n=5*10^5,Y1=Y[,1],Y2=Y[,2],Y3=Y3,D,parprior=c(2,2),
	theta0=c(0.5,0.5),hidden,parprop=c(0.1,0.1),savepar=50)

## Graphiques 
par(mfrow=c(2,2))
burn=200
## Echantillon a posteriori marginal pour theta1
i=1
# Chaîne
plot((1+0:(nrow(temp$theta)-1)*temp$savepar)[-(1:burn)],temp$theta[-(1:burn),i],
	ylim=c(0,1.5),col=grey(0.7),type="l",xlab="Itération",ylab=expression(theta[1]),axes=F)
box()
axis(1,at=c(0,2.5*10^5, 5*10^5))
axis(2)
abline(h=theta[i],col=1,lwd=1.5)
# Histogramme
hist(temp$theta[-(1:burn),i],breaks=seq(0,1.5,0.075),freq=FALSE,xlim=c(0,1.5),
	xlab=expression(theta[1]),ylab="Densité",main="",ylim=c(0,5.5),col=grey(0.7),border=grey(0.7))
abline(v=theta[i],col=1,lwd=1.5)
lines(seq(0,5,l=200),prior(cbind(seq(0,5,l=200),seq(0,5,l=200)),temp$parprior)[,i],col=1,
	lwd=1.5,lty="dotted")
box()
## Echantillon a posteriori marginal pour theta2
i=2	
# Chaîne
plot((1+0:(nrow(temp$theta)-1)*temp$savepar)[-(1:burn)],temp$theta[-(1:burn),i],
	ylim=c(0,0.2),col=grey(0.7),type="l",xlab="Itération",ylab=expression(theta[2]),axes=F)
box()
axis(1,at=c(0,2.5*10^5, 5*10^5))
axis(2)
abline(h=theta[i],col=1,lwd=1.5)
# Histogramme
hist(temp$theta[-(1:burn),i],breaks=seq(0,0.2,0.0075),freq=FALSE,xlim=c(0,0.2),
	xlab=expression(theta[2]),ylab="Densité",main="",ylim=c(0,55),col=grey(0.7),border=grey(0.7))
abline(v=theta[i],col=1,lwd=1.5)
lines(seq(0,5,l=200),prior(cbind(seq(0,5,l=200),seq(0,5,l=200)),temp$parprior)[,i],col=1,
	lwd=1.5,lty="dotted")
box()
## Echantillon a posteriori joint 
par(mfrow=c(1,1))
th=expand.grid(seq(0,1.5,l=20),seq(0,0.2,l=20))
pp=prior(th,temp$parprior)
pp=matrix(pp[,1]*pp[,2],20,20)
contour(seq(0,1.5,l=20),seq(0,0.2,l=20),z=pp,xlim=c(0,1.5),ylim=c(0,0.2),col=0,
	xlab=expression(theta[1]),ylab=expression(theta[2]),labcex=1.5,lwd=1.5)
points(temp$theta[-(1:burn),1],temp$theta[-(1:burn),2],pch=".",col=grey(0.7))
contour(seq(0,1.5,l=20),seq(0,0.2,l=20),z=pp,col=1,lwd=1.5,labcex=1.5,add=TRUE)
points(theta[1],theta[2],col=1,lwd=2,pch=19,cex=1)


