rm(list = ls())
alpha1<-0.04
alpha2<-0.1
alpha3<-0.2
alpha4<-0.3
d<-seq(0,10,0.01)

pd1<-1-exp(-alpha1*d)
pd2<-1-exp(-alpha2*d)
pd3<-1-exp(-alpha3*d)
pd4<-1-exp(-alpha4*d)

x1<-rbinom(1001,10,pd1)
x2<-rbinom(1001,10,pd2)
x3<-rbinom(1001,10,pd3)
x4<-rbinom(1001,10,pd4)

#windows(); 
res <- 6
name_figure <- "fig1.png"
png(filename = name_figure, height = 500*res, width = 500*res, res=72*res)

plot(d,pd1, lty=4,type="l",
	ylab="p(d)", main="", xlab="dose (d)",xlim=c(0,10), ylim=c(0,1))
lines(d, pd2, lty=3)
lines(d, pd3,lty=2)
lines(d, pd4,lty=1)
dev.off()

#windows(); 
res <- 6
name_figure <- "figureX_d.png"
png(filename = name_figure, height = 500*res, width = 500*res, res=72*res)

par(mfrow=c(2,2))

plot(x4,pd4,
	ylab="p(d)", main="", xlab=expression(paste(X[d])),xlim=c(0,10), ylim=c(0,1))
plot(x3,pd3,
	ylab="p(d)", main="", xlab=expression(paste(X[d])),xlim=c(0,10), ylim=c(0,1))
plot(x2,pd2,
	ylab="p(d)", main="", xlab=expression(paste(X[d])),xlim=c(0,10), ylim=c(0,1))
plot(x1,pd1,
	ylab="p(d)", main="", xlab=expression(paste(X[d])),xlim=c(0,10), ylim=c(0,1))	
dev.off()